import sys
sys.path.append('\\baseball')
from init import *
from mlbref12 import *

import datetime
yesterday = datetime.date(2012,9,15)
#yesterday = datetime.date.today() - datetime.timedelta(1)
yesterymd = yesterday.strftime("%Y%m%d")

curfile = open("lineups.csv","wb")  #wb needed to avoid blank lines
curwriter = csv.writer(curfile)

br = Browser()

#Get lineups for yesterday's games (schedule in cursched.csv)
schedfile = open("cursched.csv")
schedreader = csv.reader(schedfile)
for srow in schedreader:
  if srow[0] != yesterymd:
    continue

  date = srow[0]
  awayteam = srow[1]
  hometeam = srow[2]
  game = srow[3]
  league = srow[4]
  gamenum = int(srow[5])
  print srow[0],awayteam,hometeam,league

  urldate = yesterymd[:4] + "_" + yesterymd[4:6] + "_" + yesterymd[6:] + "_"
  #rem url uses default teamids (not mlb teamids) from mlbref
  cururl = "http://mlb.mlb.com/news/boxscore.jsp?gid=" + urldate + awayteam.lower() + "mlb_" + hometeam.lower() + "mlb_" + game
  curpage = br.open(cururl)
  curhtml = curpage.read()
  cursoup = BeautifulSoup(curhtml)
  if cursoup.find(text=re.compile("Failed to retrieve boxscore")) != None:
    print "  Lineup not found"
    continue

  #Find both starting lineups (away team is first)
  #Also write players to namefile (to check against names database)

  curtable = cursoup.findAll('table',{"class" : "batting-stats"})
  if len(curtable) == 0:
    print " Lineup not found"
    continue

  for i in range(2):
    if i == 0:
      awaylineup = []
    else:
      homelineup = []

    for row in curtable[i].findAll('tr')[1:]:  #Skip first row
      #Column has attribute class='player-name' for starters, class='player-name ph' for subs
      starter = row.find('td',{"class" : "player-name"})
      #First column has playerid in href attribute of 'a' tag, name is text of 'a' tag
      atag = row.find('td').find('a')
      if atag == None:  #Check for last row Totals which has no a tag
        break
      href = atag['href']
      #playerid is last 6 characters in href
      playerid = href[len(href)-6:]
      playername = atag.text

      #Add to lineup if a starter
      if starter != None:
        if i == 0:
          awaylineup.append(playerid)
          team = awayteam
        else:
          homelineup.append(playerid)
          team = hometeam

  #Find pitchers (away team is first)
  curtable = cursoup.findAll('table',{"class" : "pitching-stats"})
  for i in range(2):
    curcount = 0
    for row in curtable[i].findAll('tr')[1:]:  #Skip first row
      curcount = curcount + 1
      atag = row.find('td').find('a')
      if atag == None:  #Check for last row Totals which has no a tag
        break
      href = atag['href']
      #playerid is last 6 characters in href
      playerid = href[len(href)-6:]
      playername = atag.text

      #Add to lineup if first row (starter)
      if curcount == 1:
        if i == 0:
          awaylineup.append(playerid)
          team = awayteam
        else:
          homelineup.append(playerid)
          team = hometeam

  #Write out lineup, put starting pitcher before lineup
  for i in range(2):
    if i == 0:
      currecord = (date,gamenum,awayteam,"A",game,league,awaylineup[9],awaylineup[0],awaylineup[1],awaylineup[2],awaylineup[3],awaylineup[4],awaylineup[5],awaylineup[6],awaylineup[7],awaylineup[8])
    else:
      currecord = (date,gamenum,hometeam,"H",game,league,homelineup[9],homelineup[0],homelineup[1],homelineup[2],homelineup[3],homelineup[4],homelineup[5],homelineup[6],homelineup[7],homelineup[8])
    curwriter.writerow(currecord)

curfile.close()
schedfile.close()
